 ; Chaos: a system which appears to demonstrate chaotic behaviour.
 ; Copyright 1992, 2005 by Rocket Software Ltd.
 ; Chaos - hobby, lifestyle, civilisation.

 ; Zoop - zoom extents 
 ; Calls nothing, Returns nothing.
 (defun zoop (/ a vs ctr w maxx minx maxy miny xpos ypos)
  (setq a (getvar "screensize"))        ; view height & width (pixels)
  (setq a (/ (car a) (cadr a)))         ; view width/height ratio
  (setq vs (* (getvar "viewsize") 0.5)) ; view height in drawing units
  (setq ctr (getvar "viewctr"))         ; centre point of screen
  (setq w (* vs a ))                    ; view half width
  (setq maxx (+ (car ctr) w))           ; max x coord
  (setq minx (- (car ctr) w))           ; min x coord
  (setq maxy (+ (cadr ctr) vs))         ; max y coord
  (setq miny (- (cadr ctr) vs))         ; min y coord
  (setq xpos (car pa))
  (setq ypos (cadr pa))
  (if (or (> xpos maxx) (< xpos minx) (> ypos maxy) (< ypos miny))
      (command "zoom" "E"))
 (princ))

 (DEFUN C:CHAOS (/ *error* num reps rps goc coll cycles col cinc lina lintyp
                   pa pb len1 len2 len tenx elvx teny elvy mid light linang
                                                       litang difang nuangl)
  (setvar "cmdecho" 0)
  (command "undo" "be")
 ; Ŀ
 ;   Make a local error handler.                                           
 ; 
  (defun *error* (shk)
   (if coll (command "color" coll))
   (command "undo" "end")
  (princ))
 ; Ŀ
 ;   Get the number of cycles between extents checking.                    
 ; 
  (setq num 0)
  (if (/= (type reps) 'INT) (setq reps 250))
  (setq rps (getint (strcat "Cycles between zoom checks <" (itoa reps) ">: ")))
  (if rps (setq reps rps))
 ; Now see if they want colour cycling (included despite misgivings).
  (initget 0 "Yes No")
  (setq goc (getkword "\nColour cycling? <Emphatically not>: "))
  (if (or (null goc) (= goc "No"))
      (setq goc ()))
  (if goc 
      (progn
          (setq coll (getvar "cecolor"))           ; save previous colour
          (cond ((= coll "BYLAYER") (setq coll "BYLAYER")) ; and change to
                ((= coll "BYBLOCK") (setq coll "BYBLOCK")) ; format accepted
                (t (setq coll (read coll))))               ; by colour cmd
          (setq cycles (getint "Cycles per colour <10>: "))
          (if (null cycles) (setq cycles 10))
          (setq col 1)                             ; initialize colour
          (setq cinc (/ 1.0 cycles))))             ; incr per cycle, progend
 ; At this point want to give the user the option of continuing from the end
 ; of an existing line (so that he can pick up at the end of an existing
 ; pattern) or of drawing his own start line.
  (setq lina (entsel "Pick target line or <Return> to draw: "))
  (if lina
      (progn
          (setq lina (entget (car lina)))
          (setq lintyp (cdr (assoc 0 lina)))
          (if (/= lintyp "LINE") (setq lintyp ())))
      (progn
          (setq pa (getpoint "Start point: "))
          (setq pb (getpoint pa "\nAnd endpoint: "))
          (command "line" pa pb "")
          (setq lina (entget (entlast)))
          (setq lintyp T)))
 ; Now Lina is the elist for the target line and Lintyp is either nil (in
 ; which case quit) or = T (we drew our own line) or "LINE" (an existing
 ; entity was selected and turned out to be a line).
  (if lintyp
      (setq pa (getpoint "Start point: "))
      (progn
          (write-line "\nThat was not a line. ")
          (setq pa ())))
 ; Find the distance from pa to the closest end of the picked or drawn line -
 ; this is the length of the reflected ray and becomes the set length of all
 ; reflected lines.  (I think that the closest end is always the source of
 ; the reflected ray...)
  (if pa
      (progn
           (setq len1 (distance pa (cdr (assoc 10 lina))))
           (setq len2 (distance pa (cdr (assoc 11 lina))))
           (setq len (min len1 len2))))
  (while pa 
 ; Colour cycling - used despite misgivings - increment every n cycles:
 ; add 1/n to the variable each time and then fix a copy before using.
         (if goc
             (if (= (fix col) 7)
                 (command "color" (setq col 1))
                 (command "color" (fix (setq col (+ cinc col))))))
         (setq num (1+ num))
         (grtext -2 (itoa num))
 ; Zoom extents if the pattern has gone off the screen.
         (if (= num reps)
             (progn
                  (setq num 0)
                  (zoop)))
 ; Draw the next part of the pattern.
         (setq tenx (cadr (assoc 10 lina)))
         (setq elvx (cadr (assoc 11 lina)))
         (setq teny (caddr (assoc 10 lina)))
         (setq elvy (caddr (assoc 11 lina)))
         (setq mid (list (/ (+ tenx elvx) 2) (/ (+ teny elvy) 2)))
         (command "line" pa mid "")
         (setq light (entget (entlast)))
         (setq linang (- (angle (cdr (assoc 10 lina))
                                (cdr (assoc 11 lina))) pi))
         (setq litang (- (angle (cdr (assoc 10 light))
                                (cdr (assoc 11 light))) pi))
         (setq difang (- litang linang))
         (setq nuangl (- (+ linang pi) difang))
         (setq pa (polar mid nuangl len))
         (command "line" mid pa "")
         (setq lina light))
  (*error* "")
 (princ))